import React from 'react';

import { Tabs } from 'antd';
import type { TabsProps } from 'antd';

import Layout from '~/components/layout';

import BrushQuestionZone from './components/brushQuestionZone';
import MockExam from './components/mockExam';
import { Box } from './styled';

export default function ExaminationDateil() {
  const onChange = (key: string) => {
    console.log(key);
  };

  const items: TabsProps['items'] = [
    {
      key: '1',
      label: `刷题专区`,
      children: <BrushQuestionZone />,
    },
    {
      key: '2',
      label: `模拟考试`,
      children: <MockExam />,
    },
  ];
  return (
    <Layout>
      <Box>
        <Tabs defaultActiveKey='1' items={items} onChange={onChange} centered size='large' />
      </Box>
    </Layout>
  );
}
